# Z 字形变换

将一个给定字符串 `s` 根据给定的行数 `numRows` ，以从上往下、从左到右进行 Z 字形排列。

比如输入字符串为 `"PAYPALISHIRING"` 行数为 `3` 时，排列如下：

```
P   A   H   N
A P L S I I G
Y   I   R
```

之后，你的输出需要从左往右逐行读取，产生出一个新的字符串，比如：`"PAHNAPLSIIGYIR"`。

请你实现这个将字符串进行指定行数变换的函数：

```c
string convert(string s, int numRows);
```

**示例 1：**

**输入：** s = "PAYPALISHIRING", numRows = 3

**输出：** "PAHNAPLSIIGYIR"
    

**示例 2：**

**输入：** s = "PAYPALISHIRING", numRows = 4

**输出：** "PINALSIGYAHRPI"

**解释：**

```
P     I    N
A   L S  I G
Y A   H R
P     I
```

**示例 3：**

**输入：** s = "A", numRows = 1

**输出：** "A"
    

**提示：**

  * `1 <= s.length <= 1000`

  * `s` 由英文字母（小写和大写）、`','` 和 `'.'` 组成
  
  * `1 <= numRows <= 1000`

<p>以下<span style="color:red">错误</span>的选项是？</p>

## aop

### before

```c
#include <bits/stdc++.h>
using namespace std;
```

### after

```c
int main()
{
    Solution test;

    string ret;
    string s = "LEETCODEISHIRING";
    int numrows = 3;
    ret = test.convert(s, numrows);
    cout << ret << endl;
    return 0;
}

```

## 答案

```c
class Solution
{
public:
    string convert(string s, int numRows)
    {
        string result;
        int num1 = numRows * 2 - 2;
        if (s.size() < 2 || num1 == 0)
        {
            result = s;
            return result;
        }
        int num = (s.size() / num1);
        string str[100];
        int count = 0;
        int i = 0;
        for (int j = 0; j < s.size(); j++)
        {
            if (count == num1)
            {
                i++;
                count = 0;
            }
            str[i].push_back(s[j]);
        }

        for (int n = 0; n < num; n++)
        {
            result.push_back(str[n][0]);
        }
        for (int m = 1; m < numRows; m++)
        {
            for (int n = 0; n < num; n++)
            {
                if (m < str[n].size())
                    result.push_back(str[n][m]);
                if ((num1 - m) < str[n].size() && m != (num1 - m))
                    result.push_back(str[n][num1 - m]);
            }
        }
        return result;
    }
};

```
## 选项


### A

```c
class Solution
{
public:
    string convert(string s, int numRows)
    {
        string result;
        int i = 0;
        int j = 0;
        int tem = numRows != 1 ? 2 * (numRows - 1) : 1;
        for (i = 0; i <= tem / 2; ++i)
        {
            j = i;
            while (j < s.size())
            {
                result += s[j];
                if (j % tem != 0 && j % tem != tem / 2 && j + tem - 2 * i < s.size())
                {
                    result += s[j + tem - 2 * i];
                }
                j += tem;
            }
        }
        return result;
    }
};
```

### B

```c
class Solution
{
public:
    string convert(string s, int numRows)
    {
        if (numRows == 1 || s.size() <= numRows)
            return s;
        vector<string> rows(numRows);
        int curRow = 0;
        bool goingDown = false;
        for (char c : s)
        {
            rows[curRow] += c;
            if (curRow == 0 || curRow == numRows - 1)
                goingDown = !goingDown;
            curRow += goingDown ? 1 : -1;
        }
        string ret;
        for (string row : rows)
            ret += row;
        return ret;
    }
};
```

### C

```c
class Solution
{
public:
    string convert(string s, int numRows)
    {
        if (s.size() <= numRows || numRows <= 1)
            return s;
        int len = s.size();
        vector<vector<char> > pos(len, vector<char>(numRows));
        int k = 0;
        int flag = numRows - 1;
        for (int i = 0; i < len; i++)
        {
            for (int j = 0; j < numRows; j++)
            {
                if (i % (numRows - 1) == 0 || numRows == 2)
                {
                    pos[i][j] = s[k];
                    k++;
                }
                else if (j == flag - 1)
                {
                    pos[i][j] = s[k];
                    k++;
                    flag--;
                }
                else
                    continue;
                if (k == len)
                    break;
            }
            if (k == len)
                break;
            if (flag == 1)
                flag = numRows - 1;
        }
        string res;
        for (int j = 0; j <= numRows; j++)
        {
            int count = 0;
            for (int i = 0; i < len; i++)
            {
                if (j % (numRows - 1) == 0 && pos[i][j] != '\0')
                {
                    res = res + pos[i][j];
                    i = i + numRows - 2;
                    count = 0;
                    continue;
                }
                else if (j % (numRows - 1) != 0 && pos[i][j] != '\0')
                {
                    res = res + pos[i][j];
                    count = 0;
                    continue;
                }
                else
                    count++;
                if (count >= numRows)
                    break;
            }
            if (res.size() == len)
                break;
        }
        return res;
    }
};
```
